<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       market/market/card.php
 * \ingroup    market
 * \brief      markets CRUD
 */

require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/market/metre_headers/class/metre_headers.class.php');
dol_include_once('/btp/class/tender.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
dol_include_once('/btp/market/work_metres/class/work_metres.class.php');
dol_include_once('/btp/market/works/class/works.class.php');


$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/market/contract/class/btp_contract.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/nc_under_modules/marches/lib/tools.lib.php');
// Protection if external user
if (!$user) accessforbidden();

$langs->load('users');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id      = GETPOST('id', 'int');
$cont_id     = GETPOST('cont_id', 'int');
$error 	= false;
$header = new MetreHeaders($db);
$metre=new MarketWorkMetres($db);
$works=new MarketWorks($db);
$market=new Market($db);


$request_method = $_SERVER['REQUEST_METHOD'];
if ($action == 'create' && $request_method === 'POST') {
    $fk_createdby     = $user->id;
     $bloc        = trim($_POST['bloc']);
     $niveau           = trim($_POST['niveau']);
    $operation           = trim($_POST['operation']);
    $metreid           = trim($_POST['metreid']);
   
                  
    if (!$error) {
       
            $header->fk_createdby  = $user->id;
            $header->fk_metre     = $metre_id;
            $header->operation  = $operation;
            $header->block  = $bloc;
            $header->level  = $level;
     if (!$metre_id  || $niveau=="" || $operation=="") {
            header('Location: ./index.php?metre_id='.$metre_id);
            return;
        }
        $created = $header->create();
        if ($created) {
          header('Location: ./index.php?metre_id='.$metre_id.'&id='.$created);
          } else {
            header("Location: ./index.php?error=SQL_Create&msg=". $header->error);
        }
        die();
    }
}
if ($action == 'update' && $request_method === 'POST') {
    //$metre_id     = (int)$_POST['metre_id'];
    $header_id     = (int)$_POST['header_id'];
    $blocks     = trim($_POST['blocks']);
    $operation        = trim($_POST['operations']);
    $levels            = trim($_POST['levels']);
    if (!$error) {
        $data = array(
    		"fk_metre"     => $metre_id,
            "block"          => $blocks,
            "operation"       => $operation,
            "level"           => $levels,
        );

          if (!$metre_id  || $levels=="" || !$header_id ) {
     header('Location: ./index.php?metre_id='.$metre_id);
            return;
        }
    	$upated = $header->update($header_id, $data);
    	if ($upated) {
	    	  header('Location: ./index.php?metre_id='.$metre_id.'&id='.$header_id);
      die();
    	} else {
    		header("Location: ./index.php?metre_id=".$metre_id."&id=". $header_id."&error=SQL_Create&msg=". $header->error);
	    	die();
    	}
    }
}
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes') {
    $error=0;

    $db->begin();

    $canDelete = true;
     if ($canDelete) {
        $header->delete((int)$id);
    }
    else {
        $error = $langs->trans('ErrorCantDelete');
    }

    header('Location: index.php?leftmenu=btp');
    
    if (!$error) {
        $db->commit();
        exit;
    }
    else {
        $db->rollback();
        header('Location: index.php?leftmenu=btp');
        exit;
    }
}

/*
 * View
 */

$form    = new Form($db);
$morejs  = array("/btp/js/btp.js");
$morecss = array();
$tender = new Tender($db);
$metre = new MarketWorkMetres($db);

llxHeader(array(), $langs->trans('ListOfMarkets'),'','','','',$morejs,$morecss,0,0);

if ($action == 'add' || $action == 'create') {
/*$metre->fetch($metre_id);
$works->fetch($metre->fk_td_work);
$market->fetch($works->fk_market);
*/
$head  = soustraitance_prepare_head($cont_id);
    dol_fiche_head($head, 'bordreCont', $langs->trans("BordreCont"), 0, '');

    


        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">';
        print '<input type="hidden" name="action" value="create" />';
        print '<input type="hidden" name="metre_id" value="'.$metre_id.'" />';
        print '<table class="border" width="100%">';
        print '<tbody>';
        print '<tr><td>'.$langs->trans("operation").'</td><td>';
        print '<input type="text" class="flat" name="operation"  required ="required" /></td></tr>';
        print '<tr><td>'.$langs->trans("Bloc").'</td><td>';
        print '<input type="text" class="flat" name="bloc" required ="required"/></td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("Niveau").'</td><td>';
        print '<input type="text" class="flat" name="niveau" required ="required"/></td></tr>';

        
        print '</tbody>';
        print '</table><br />';

        print '<div align="right">';
        // Boutons d'actions
        print '<input type="submit" class="butAction" value="'. $langs->trans('AddHeader') .'">';
        print '</div>';

        dol_fiche_end();
    // }
}
else if ($id || $action == 'edit' || $action == 'update') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->markets->write) || empty($user->rights->markets->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'cantDelete' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'markerN' :
                    $errors[] = $langs->trans('MarketNError');
                    break;
                case 'markerL' :
                    $errors[] = $langs->trans('MarketLError');
                    break;
                case 'markerD' :
                    $errors[] = $langs->trans('MarketDError');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

		$canedit = true;/*($user->rights->markets->delete || $user->rights->markets->write_all);*/
        
        if ($canedit) {

            
$obj=new MetreHeaders($db);
$metre->fetch($metre_id);
$works->fetch($metre->fk_td_work);
$market->fetch($works->fk_market);
$obj->fetch($id);
$head  = market_prepare_head($market);
    dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

    $work_metresHead  = market_works_prepare_head($works);
    dol_fiche_head($work_metresHead, 'work_metres', $langs->trans("Metres"), 0, 'submunu');
    
    $work_Head  = market_works_metre_prepare_head($metre);
        dol_fiche_head($work_Head,'metre_headers', $langs->trans("Headers"), 0, 'submunu1');
    


            if ($action == 'edit') {
                $edit = true;
                print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">';
                print '<input type="hidden" name="action" value="update" />';
                print '<input type="hidden" name="metre_id" value="'.$metre_id.'" />';  
                print '<input type="hidden" name="header_id" value="'.$id.'" />';

                print '<table class="border" width="100%">';
                print '<tbody>';

                print '<tr><td>'.$langs->trans("Niveau").'</td><td>';
                print '<input type="text" class="flat" name="levels" required="required" value="'. $obj->level .'" /></td></tr>';

                print '<tr><td>'.$langs->trans("Operation").'</td><td>';
                print '<input type="text" class="flat" name="operations" value="'. $obj->operation .'" required="required" /></td></tr>';

                print '<tr><td valign="top" class="fieldrequired">'.$langs->trans("Bloc").'</td><td>';
               
                print '<textarea cols="60" rows="10" name="blocks" required="required">'. $obj->block .'</textarea></td></tr>';

                print '</tbody>';
                print '</table><br />';

                print '<div class="center">';
                // Boutons d'actions
                print '<input type="submit" class="butAction" value="'. $langs->trans('Modify') .'">';

                print '</div>';
            }

            dol_fiche_end();

        }
    // }
}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>
